<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.09.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName("Berechtigungen");
requireLogin();
requireRole(['Auditor', 'Administrator']);
include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');

?>
<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-3 mb-md-0">Berechtigungen</h4>
        <span class="text-secondary">Auditing</span>
    </div>
</div>

<div class="row">
    <div class="col-lg-12 col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Benutzerkonten
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th style="white-space: nowrap; width: 1%;">Typ</th>
                                <th width="20%">Benutzername</th>
                                <th width="20%">Vollständiger Name</th>
                                <th>Benutzerrolle</th>
                                <th style="white-space: nowrap; width: 1%;">Letzter Login</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php

                            // Datenbankverbindung
                            initializeDatabaseConnection();

                            // Datenbankabfrage
                            $sql = "SELECT Type, Username, DisplayName, Role, LastLogin FROM Accounts";
                            $stmt = $pdo->query($sql);
                            $Accounts = $stmt->fetchAll();

                            // Überprüfen, ob Datensätze vorhanden sind
                            if ($Accounts) {
                                // Ausgabe der Daten
                                foreach ($Accounts as $account) {
                                    echo "<tr>";
                                    if ($account['Type'] == 'ldap') {
                                        echo '<td><span class="badge bg-primary">LDAP</span></td>';
                                    }
                                    if ($account['Type'] == 'local') {
                                        echo '<td><span class="badge bg-warning">LOKAL</span></td>';
                                    }
                                    echo "<td>" . htmlspecialchars($account['Username']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['DisplayName']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['Role']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['LastLogin']) . "</td>";
                                    echo "</tr>";
                                }
                            }

                            ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Zonenberechtigungen
            </div>
            <div class="card-body">

                <?php
                // Zonen abrufen
                $sqlZones = "SELECT ZoneID, ZoneName FROM Zones ORDER BY ZoneName";
                $stmt = $pdo->query($sqlZones);
                $zones = $stmt->fetchAll();

                // Benutzer und ihre Berechtigungen abrufen
                $sqlPermissions = "
                    SELECT 
                        Accounts.ID AS UserID,
                        Accounts.Username AS Username,
                        Accounts.Role AS Role,
                        Zones.ZoneID
                    FROM Accounts
                    LEFT JOIN ZonePermissions ON Accounts.ID = ZonePermissions.AccountID
                    LEFT JOIN Zones ON ZonePermissions.ZoneID = Zones.ZoneID
                    ORDER BY Accounts.Username, Zones.ZoneName
                ";
                $stmt = $pdo->query($sqlPermissions);
                $permissions = $stmt->fetchAll();

                // Daten für die Tabelle aufbereiten
                $users = [];
                foreach ($permissions as $row) {
                    $userId = $row['UserID'];
                    if (!isset($users[$userId])) {
                        $users[$userId] = [
                            'Username' => $row['Username'],
                            'Role' => $row['Role'],
                            'Zones' => []
                        ];
                    }
                    // Benutzer mit Berechtigungen verknüpfen
                    if ($row['ZoneID']) {
                        $users[$userId]['Zones'][] = $row['ZoneID'];
                    }
                }
                ?>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th></th>
                                <?php foreach ($zones as $zone): ?>
                                    <th width="5%" style="writing-mode: vertical-lr;">
                                        <?= htmlspecialchars($zone['ZoneName']) ?>
                                    </th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?= htmlspecialchars($user['Username']) ?></td>
                                    <?php foreach ($zones as $zone): ?>
                                        <td class="text-center">
                                            <?php if ($user['Role'] === 'Administrator' || $user['Role'] === 'Bearbeiter'): ?>
                                                <i class="fs-16px text-success mdi mdi-check-bold"></i>
                                            <?php elseif (in_array($zone['ZoneID'], $user['Zones'])): ?>
                                                <i class="fs-16px text-success mdi mdi-check-bold"></i>
                                            <?php else: ?>

                                            <?php endif; ?>
                                        </td>
                                    <?php endforeach; ?>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Rechte-Matrix
            </div>
            <div class="card-body">

                <div class="alert alert-primary" role="alert">
                    <i class="mdi mdi-information-slab-box-outline"></i>
                    Diese Funktion ist aktuell unvollständig und wird mit der nächsten Softwarepflege eingeführt.
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                        <thead>
                            <tr>
                                <th></th>
                                <th width="5%" style="writing-mode: vertical-lr;">Bediener</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Bearbeiter</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Auswerter</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Auditor</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Administrator</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Dashboard</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Berichte
                                </td>
                            </tr>
                            <tr>
                                <td>Zonenauswertung</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Schutzräume</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Sicherheitsbelehrungen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Militärische Abschirmdienst</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Identitäten
                                </td>
                            </tr>
                            <tr>
                                <td>Dienstposten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Identitäten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Auditing
                                </td>
                            </tr>
                            <tr>
                                <td>Berechtigungen Einsehen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Protokolle Einsehen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Buchungshistorie Einsehen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Administration
                                </td>
                            </tr>
                            <tr>
                                <td>Benutzerkonten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Zonen Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Schutzräume Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Backup Erstellen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>




<?php include('../footer.inc.php'); ?>

<!-- Funktionen für Datentabellen -->
<link rel="stylesheet" href="../assets/vendors/datatables.net-bs5/dataTables.bootstrap5.css">
<script src="../assets/vendors/datatables.net/dataTables.js"></script>
<script src="../assets/vendors/datatables.net-bs5/dataTables.bootstrap5.js"></script>
<script src="../assets/js/data-table.js"></script>